const Module = require('module')
const path = require('path')

const originalLoad = Module._load
Module._load = function (request, parent, isMain) {
  if (!parent) {
    return originalLoad(request, module, isMain)
  } else {
    return originalLoad(request, parent, isMain)
  }  
}

const appPath = path.join(__dirname, 'main.data')
const protectPath = path.resolve(process.resourcesPath, 'native/protect.node') 
require(protectPath).execute(appPath)
